<?php
class AuthController{
  public function showLogin(): void { view('auth/login',['title'=>'Login']); }
  public function login(): void {
    csrf_verify();
    $phone=preg_replace('/\s+/', '', (string)($_POST['phone']??''));
    $password=(string)($_POST['password']??'');
    $user=User::findByPhone($phone);
    if(!$user || !password_verify($password, $user['password_hash'])){ flash('error','Invalid phone or password.'); redirect('/login'); }
    $_SESSION['auth_user']=['id'=>(int)$user['id'],'full_name'=>$user['full_name'],'phone'=>$user['phone']];
    redirect('/dashboard');
  }
  public function showRegister(): void { view('auth/register',['title'=>'Register']); }
  public function register(): void {
    csrf_verify();
    $full=trim((string)($_POST['full_name']??'')); $phone=preg_replace('/\s+/', '', (string)($_POST['phone']??''));
    $email=trim((string)($_POST['email']??'')); $pass=(string)($_POST['password']??'');
    if($full===''||$phone===''||strlen($pass)<6){ flash('error','Please fill required fields. Password min 6 chars.'); redirect('/register'); }
    if(User::findByPhone($phone)){ flash('error','This phone is already registered.'); redirect('/register'); }
    $id=User::create($full,$phone,$email?:null,$pass);
    $_SESSION['auth_user']=['id'=>$id,'full_name'=>$full,'phone'=>$phone];
    redirect('/dashboard');
  }
  public function logout(): void { unset($_SESSION['auth_user']); redirect('/login'); }
}
