<?php
class DeviceController{
  public function index(): void { require_user(); $devices=Device::allForUser((int)auth_user_id()); view('devices/index',['title'=>'My Devices','devices'=>$devices]); }
  public function addForm(): void { require_user(); view('devices/add',['title'=>'Add Device']); }
  public function add(): void {
    require_user(); csrf_verify();
    $barcode=trim((string)($_POST['barcode']??'')); $productTitle=trim((string)($_POST['product_title']??'')); $storeName=trim((string)($_POST['store_name']??''));
    if($barcode===''||$storeName===''){ flash('error','Barcode and store name are required.'); redirect('/devices/add'); }
    if(!isset($_FILES['invoice'])||$_FILES['invoice']['error']!==UPLOAD_ERR_OK){ flash('error','Invoice upload is required.'); redirect('/devices/add'); }

    $maxBytes=(int)app_config('upload_max_mb',5)*1024*1024;
    if((int)$_FILES['invoice']['size']>$maxBytes){ flash('error','Invoice file is too large.'); redirect('/devices/add'); }

    $tmp=$_FILES['invoice']['tmp_name']; $origName=(string)($_FILES['invoice']['name']??'invoice');
    $ext=strtolower(pathinfo($origName, PATHINFO_EXTENSION));
    if(!in_array($ext,['jpg','jpeg','png','pdf'],true)){ flash('error','Invalid file type. Allowed: jpg, png, pdf'); redirect('/devices/add'); }

    $finfo=new finfo(FILEINFO_MIME_TYPE); $mime=$finfo->file($tmp)?:'';
    $allowed=['image/jpeg','image/png','application/pdf'];
    if(!in_array($mime,$allowed,true)){ flash('error','Invalid file mime type.'); redirect('/devices/add'); }

    $ym=date('Y/m'); $dir=storage_path('uploads/invoices/'.$ym); ensure_dir($dir);
    $safe=bin2hex(random_bytes(16)).'.'.$ext; $dest=$dir.'/'.$safe;
    if(!move_uploaded_file($tmp,$dest)){ flash('error','Upload failed.'); redirect('/devices/add'); }

    $pdo=DB::pdo(); $pdo->beginTransaction();
    try{
      $deviceId=Device::create((int)auth_user_id(),$barcode,$productTitle?:null);
      $rel='uploads/invoices/'.$ym.'/'.$safe;
      WarrantyRequest::create($deviceId,$storeName,$rel,$origName);
      $pdo->commit();
    }catch(Exception $e){
      $pdo->rollBack(); @unlink($dest);
      flash('error','DB error: '.$e->getMessage()); redirect('/devices/add');
    }
    flash('success','Device registered. Waiting for warranty approval.');
    redirect('/devices');
  }

  public function show(array $params): void {
    require_user();
    $id=(int)($params['id']??0);
    $device=Device::findForUser($id,(int)auth_user_id());
    if(!$device){ http_response_code(404); echo 'Device not found.'; return; }
    $wr=WarrantyRequest::latestForDevice($id);
    view('devices/show',['title'=>'Device Details','device'=>$device,'wr'=>$wr]);
  }

  public function invoiceDownload(array $params): void {
    require_user();
    $id=(int)($params['id']??0);
    $device=Device::findForUser($id,(int)auth_user_id());
    if(!$device){ http_response_code(404); echo 'Not found'; return; }
    $wr=WarrantyRequest::latestForDevice($id);
    if(!$wr){ http_response_code(404); echo 'Not found'; return; }
    $rel=(string)$wr['invoice_path'];
    if(strpos($rel,'..')!==false){ http_response_code(400); echo 'Bad path'; return; }
    $abs=storage_path($rel);
    if(!is_file($abs)){ http_response_code(404); echo 'File not found'; return; }
    $name=$wr['invoice_original_name']?:basename($abs);
    $mime=(new finfo(FILEINFO_MIME_TYPE))->file($abs)?:'application/octet-stream';
    header('Content-Type: '.$mime);
    header('Content-Disposition: attachment; filename="'.str_replace('"','',$name).'"');
    header('Content-Length: '.filesize($abs));
    readfile($abs); exit;
  }
}
