<?php
class OperatorAuthController{
  public function showLogin(): void { view('operator/login',['title'=>'Operator Login']); }
  public function login(): void {
    csrf_verify();
    $email=strtolower(trim((string)($_POST['email']??''))); $password=(string)($_POST['password']??'');
    $staff=Staff::findByEmail($email);
    if(!$staff || !password_verify($password, $staff['password_hash'])){ flash('error','Invalid email or password.'); redirect('/op/login'); }
    $_SESSION['auth_staff']=['id'=>(int)$staff['id'],'full_name'=>$staff['full_name'],'email'=>$staff['email'],'role'=>$staff['role']];
    redirect('/op/requests');
  }
  public function logout(): void { unset($_SESSION['auth_staff']); redirect('/op/login'); }
}
