<?php
class OperatorController{
  public function requests(): void {
    require_staff(['operator','admin']);
    $status=$_GET['status']??'pending';
    if(!in_array($status,['pending','approved','rejected'],true)) $status='pending';
    $items=WarrantyRequest::allForOperator($status);
    view('operator/requests',['title'=>'Warranty Requests','items'=>$items,'status'=>$status]);
  }

  public function requestShow(array $params): void {
    require_staff(['operator','admin']);
    $id=(int)($params['id']??0);
    $req=WarrantyRequest::find($id);
    if(!$req){ http_response_code(404); echo 'Not found'; return; }
    view('operator/request_show',['title'=>'Request #'.$id,'req'=>$req]);
  }

  public function decide(array $params): void {
    require_staff(['operator','admin']);
    csrf_verify();
    $id=(int)($params['id']??0);
    $req=WarrantyRequest::find($id);
    if(!$req){ http_response_code(404); echo 'Not found'; return; }
    $action=$_POST['action']??''; $note=trim((string)($_POST['note']??''));
    if(!in_array($action,['approve','reject'],true)){ flash('error','Invalid action.'); redirect('/op/requests/'.$id); }
    $status=($action==='approve')?'approved':'rejected';
    WarrantyRequest::decide($id,(int)staff_id(),$status,$note?:null);
    if($status==='approved'){
      $start=date('Y-m-d'); $end=date('Y-m-d', strtotime('+365 days'));
      Warranty::upsertForDevice((int)$req['device_id'],$start,$end);
    }
    flash('success','Request updated: '.$status);
    redirect('/op/requests?status='.$status);
  }
}
