<?php
class DB{
  private static $pdo=null;
  public static function pdo(): PDO{
    if(self::$pdo instanceof PDO) return self::$pdo;
    $cfg=require BASE_PATH.'/config/db.php';
    $dsn="mysql:host={$cfg['host']};dbname={$cfg['name']};charset={$cfg['charset']}";
    self::$pdo=new PDO($dsn,$cfg['user'],$cfg['pass'],[
      PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES=>false,
    ]);
    return self::$pdo;
  }
}
