<?php
class Device{
  public static function allForUser(int $userId): array{
    $st=DB::pdo()->prepare("SELECT d.*, w.start_date, w.end_date FROM devices d LEFT JOIN warranties w ON w.device_id=d.id WHERE d.user_id=? ORDER BY d.id DESC");
    $st->execute([$userId]); return $st->fetchAll()?:[];
  }
  public static function create(int $userId,string $barcode,?string $productTitle): int{
    $st=DB::pdo()->prepare("INSERT INTO devices (user_id,barcode,product_title) VALUES (?,?,?)");
    $st->execute([$userId,$barcode,$productTitle]); return (int)DB::pdo()->lastInsertId();
  }
  public static function findForUser(int $deviceId,int $userId): ?array{
    $st=DB::pdo()->prepare("SELECT d.*, w.start_date, w.end_date FROM devices d LEFT JOIN warranties w ON w.device_id=d.id WHERE d.id=? AND d.user_id=? LIMIT 1");
    $st->execute([$deviceId,$userId]); $row=$st->fetch(); return $row?:null;
  }
}
