<?php
class WarrantyRequest{
  public static function create(int $deviceId,string $storeName,string $invoicePath,string $origName): int{
    $st=DB::pdo()->prepare("INSERT INTO warranty_requests (device_id,store_name,invoice_path,invoice_original_name,status) VALUES (?,?,?,?, 'pending')");
    $st->execute([$deviceId,$storeName,$invoicePath,$origName]); return (int)DB::pdo()->lastInsertId();
  }
  public static function latestForDevice(int $deviceId): ?array{
    $st=DB::pdo()->prepare("SELECT * FROM warranty_requests WHERE device_id=? ORDER BY id DESC LIMIT 1");
    $st->execute([$deviceId]); $row=$st->fetch(); return $row?:null;
  }
  public static function allForOperator(string $status='pending'): array{
    $st=DB::pdo()->prepare("SELECT wr.*, u.full_name user_name, u.phone user_phone, d.barcode barcode, d.product_title product_title FROM warranty_requests wr JOIN devices d ON d.id=wr.device_id JOIN users u ON u.id=d.user_id WHERE wr.status=? ORDER BY wr.id DESC");
    $st->execute([$status]); return $st->fetchAll()?:[];
  }
  public static function find(int $id): ?array{
    $st=DB::pdo()->prepare("SELECT wr.*, u.full_name user_name, u.phone user_phone, d.barcode barcode, d.product_title product_title FROM warranty_requests wr JOIN devices d ON d.id=wr.device_id JOIN users u ON u.id=d.user_id WHERE wr.id=? LIMIT 1");
    $st->execute([$id]); $row=$st->fetch(); return $row?:null;
  }
  public static function decide(int $id,int $operatorId,string $status,?string $note): void{
    $st=DB::pdo()->prepare("UPDATE warranty_requests SET status=?, operator_id=?, decision_note=?, decided_at=NOW() WHERE id=?");
    $st->execute([$status,$operatorId,$note,$id]);
  }
}
