<?php
class Router{
  private array $routes = [];

  public function get(string $path, $handler): void { $this->map('GET', $path, $handler); }
  public function post(string $path, $handler): void { $this->map('POST', $path, $handler); }

  private function map(string $method, string $path, $handler): void {
    $this->routes[] = [$method, $this->norm($path), $handler];
  }

  private function norm(string $p): string {
    if ($p === '') return '/';
    if ($p[0] !== '/') $p = '/' . $p;
    return rtrim($p, '/') ?: '/';
  }

  private function baseDir(): string {
    $script = (string)($_SERVER['SCRIPT_NAME'] ?? '/index.php');
    $dir = str_replace('\\', '/', dirname($script));
    $dir = rtrim($dir, '/');
    if ($dir === '' || $dir === '/') return '';
    return $dir;
  }

  private function startsWith(string $haystack, string $needle): bool {
    if ($needle === '') return true;
    return strncmp($haystack, $needle, strlen($needle)) === 0;
  }

  private function cur(string $uri): string {
    $p = (string)(parse_url($uri, PHP_URL_PATH) ?: '/');
    $p = rtrim($p, '/') ?: '/';

    $base = $this->baseDir();
    if ($base !== '' && $p !== '/' && $this->startsWith($p, $base)) {
      $p = substr($p, strlen($base));
      $p = $p ?: '/';
      $p = rtrim($p, '/') ?: '/';
    }
    return $p;
  }

  public function dispatch(string $method, string $uri): void {
    $method = strtoupper($method);
    $path   = $this->cur($uri);

    foreach ($this->routes as $r) {
      [$m, $p, $h] = $r;
      if ($m !== $method) continue;

      $params = [];
      $pattern = preg_replace('#\{([a-zA-Z_][a-zA-Z0-9_]*)\}#', '(?P<$1>[^/]+)', $p);
      $pattern = '#^' . $pattern . '$#';

      if (preg_match($pattern, $path, $matches)) {
        foreach ($matches as $k => $v) {
          if (!is_int($k)) $params[$k] = $v;
        }
        $this->run($h, $params);
        return;
      }
    }

    http_response_code(404);
    echo '404 Not Found';
  }

  private function run($handler, array $params): void {
    if (is_array($handler) && count($handler) === 2) {
      $obj = new $handler[0]();
      $m   = $handler[1];
      $obj->$m($params);
      return;
    }
    if (is_callable($handler)) { call_user_func($handler, $params); return; }

    http_response_code(500);
    echo 'Invalid handler';
  }
}
