<?php ?><!doctype html><html lang="en"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo e($title ?? app_config('app_name','App')); ?></title>
<link rel="stylesheet" href="<?php echo e(url_path('/assets/css/app.css')); ?>">
</head><body><div class="container">
<div class="topbar">
  <div class="brand">
    <span class="badge"><?php echo e(app_config('app_name','App')); ?></span>
    <?php if (auth_user()): ?><span class="small muted">Customer: <?php echo e(auth_user()['full_name'] ?? ''); ?></span><?php endif; ?>
    <?php if (staff_user()): ?><span class="small muted">Staff: <?php echo e(staff_user()['full_name'] ?? ''); ?> (<?php echo e(staff_user()['role'] ?? ''); ?>)</span><?php endif; ?>
  </div>
  <div class="nav">
    <?php if (auth_user()): ?>
      <a href="<?php echo e(url_path('/dashboard')); ?>">Dashboard</a>
      <a href="<?php echo e(url_path('/devices')); ?>">My Devices</a>
      <a href="<?php echo e(url_path('/logout')); ?>">Logout</a>
    <?php else: ?>
      <a href="<?php echo e(url_path('/login')); ?>">Login</a>
      <a href="<?php echo e(url_path('/register')); ?>">Register</a>
    <?php endif; ?>
    <a href="<?php echo e(url_path('/op/requests')); ?>">Operator Panel</a>
    <?php if (staff_user()): ?><a href="<?php echo e(url_path('/op/logout')); ?>">Op Logout</a><?php endif; ?>
  </div>
</div>

<?php echo flash_html(); ?>
<?php require $viewFile; ?>
</div></body></html>
