<?php
declare(strict_types=1);

define('BASE_PATH', dirname(__DIR__));

// Error logging to storage/logs (works even when display_errors is off on host)
@ini_set('log_errors', '1');
@ini_set('display_errors', '0');
@ini_set('display_startup_errors', '0');

$logDir = BASE_PATH . '/storage/logs';
if (!is_dir($logDir)) { @mkdir($logDir, 0775, true); }
@ini_set('error_log', $logDir . '/php-error.log');

set_exception_handler(function($e) use ($logDir) {
  $msg = "[EXCEPTION] ".get_class($e).": ".$e->getMessage()." in ".$e->getFile().":".$e->getLine();
  @error_log($msg);
  @error_log($e->getTraceAsString());
  http_response_code(500);
  echo "Application error. Check storage/logs/php-error.log";
});

register_shutdown_function(function() {
  $err = error_get_last();
  if ($err && in_array($err['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR], true)) {
    @error_log("[FATAL] {$err['message']} in {$err['file']}:{$err['line']}");
  }
});

require BASE_PATH . '/app/helpers.php';
require BASE_PATH . '/app/Router.php';

require BASE_PATH . '/app/Models/DB.php';
require BASE_PATH . '/app/Models/User.php';
require BASE_PATH . '/app/Models/Staff.php';
require BASE_PATH . '/app/Models/Device.php';
require BASE_PATH . '/app/Models/WarrantyRequest.php';
require BASE_PATH . '/app/Models/Warranty.php';

require BASE_PATH . '/app/Controllers/AuthController.php';
require BASE_PATH . '/app/Controllers/DashboardController.php';
require BASE_PATH . '/app/Controllers/DeviceController.php';
require BASE_PATH . '/app/Controllers/OperatorAuthController.php';
require BASE_PATH . '/app/Controllers/OperatorController.php';

$GLOBALS['APP_CONFIG'] = require BASE_PATH . '/config/app.php';

if (session_status() !== PHP_SESSION_ACTIVE) {
  session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'secure' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'),
    'httponly' => true,
    'samesite' => 'Lax',
  ]);
  session_start();
}

header('X-Frame-Options: SAMEORIGIN');
header('X-Content-Type-Options: nosniff');
