<?php
function app_config(string $key, $default=null){$cfg=$GLOBALS['APP_CONFIG']??[];return $cfg[$key]??$default;}
function e(string $v): string {return htmlspecialchars($v, ENT_QUOTES, 'UTF-8');}

function starts_with(string $haystack, string $needle): bool {
  if ($needle === '') return true;
  return strncmp($haystack, $needle, strlen($needle)) === 0;
}

/** Detect base path automatically ('' if docroot is /public, or '/public' if accessed via /public/*). */
function base_path_uri(): string {
  $script = (string)($_SERVER['SCRIPT_NAME'] ?? '/index.php');
  $dir = str_replace('\\', '/', dirname($script));
  $dir = rtrim($dir, '/');
  if ($dir === '' || $dir === '/') return '';
  return $dir;
}

function url_path(string $path): string {
  $path = (string)$path;
  if (preg_match('#^https?://#i', $path) || starts_with($path, '//')) return $path;

  $base = base_path_uri();
  $path = '/' . ltrim($path, '/');

  if ($base !== '' && starts_with($path, $base . '/')) return $path;
  return ($base !== '' ? $base : '') . $path;
}

function redirect(string $path): void { header('Location: '.url_path($path)); exit; }

function view(string $name, array $data=[]): void {
  extract($data);
  $viewFile = BASE_PATH.'/app/Views/'.$name.'.php';
  if(!file_exists($viewFile)){http_response_code(500);echo 'View not found';exit;}
  require BASE_PATH.'/app/Views/layout.php';
}

function csrf_token(): string { if(empty($_SESSION['_csrf'])){$_SESSION['_csrf']=bin2hex(random_bytes(16));} return $_SESSION['_csrf']; }
function csrf_field(): string { return '<input type="hidden" name="_csrf" value="'.e(csrf_token()).'">'; }
function csrf_verify(): void {
  $t=$_POST['_csrf']??'';
  if(!$t||empty($_SESSION['_csrf'])||!hash_equals($_SESSION['_csrf'], (string)$t)){
    http_response_code(419); echo 'CSRF token mismatch.'; exit;
  }
}

function flash(string $type,string $msg): void { $_SESSION['_flash'][]=['type'=>$type,'msg'=>$msg]; }
function flash_html(): string {
  $out=''; $items=$_SESSION['_flash']??[]; unset($_SESSION['_flash']);
  foreach($items as $it){ $type=$it['type']??'success'; $msg=$it['msg']??''; $out.='<div class="alert '.e($type).'">'.e($msg).'</div>'; }
  return $out;
}

function auth_user_id(){return isset($_SESSION['auth_user']['id'])?(int)$_SESSION['auth_user']['id']:null;}
function auth_user(){return $_SESSION['auth_user']??null;}
function require_user(): void { if(!auth_user_id()) redirect('/login'); }

function staff_user(){return $_SESSION['auth_staff']??null;}
function staff_id(){return isset($_SESSION['auth_staff']['id'])?(int)$_SESSION['auth_staff']['id']:null;}
function require_staff(array $roles=[]): void {
  $s=staff_user(); if(!$s) redirect('/op/login');
  if($roles && !in_array($s['role']??'', $roles, true)){ http_response_code(403); echo 'Forbidden'; exit; }
}

function storage_path(string $rel): string { return BASE_PATH.'/storage/'.ltrim($rel,'/'); }
function ensure_dir(string $dir): void { if(!is_dir($dir)) mkdir($dir, 0775, true); }
