<?php
require __DIR__ . '/../app/bootstrap.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $full_name = trim($_POST['full_name'] ?? '');
  $email = strtolower(trim($_POST['email'] ?? ''));
  $password = (string)($_POST['password'] ?? '');
  $role = $_POST['role'] ?? 'operator';
  if (!in_array($role, ['admin','operator','repairer'], true)) $role = 'operator';
  if ($full_name === '' || $email === '' || strlen($password) < 6) { flash('error','Fill all fields. Password min 6 chars.'); redirect('/_seed_staff.php'); }
  $hash = password_hash($password, PASSWORD_DEFAULT);
  $pdo = DB::pdo();
  $stmt = $pdo->prepare("INSERT INTO staff (full_name,email,password_hash,role,is_active) VALUES (?,?,?,?,1)");
  try { $stmt->execute([$full_name,$email,$hash,$role]); flash('success','Staff created. NOW DELETE /public/_seed_staff.php'); }
  catch (Exception $e) { flash('error','Error: '.$e->getMessage()); }
  redirect('/_seed_staff.php');
}
?><!doctype html><html lang="en"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Seed Staff</title><link rel="stylesheet" href="<?php echo e(url_path('/assets/css/app.css')); ?>"></head><body>
<div class="container"><h1>Seed Staff (DELETE after use)</h1><?php echo flash_html(); ?>
<form method="post" class="card">
<label>Full name</label><input name="full_name" required>
<label>Email</label><input type="email" name="email" required>
<label>Password (min 6)</label><input type="password" name="password" required>
<label>Role</label><select name="role">
<option value="operator">operator</option><option value="admin">admin</option><option value="repairer">repairer</option>
</select><button class="btn">Create</button></form>
<p class="muted">After creating your staff user, delete this file: <b>/public/_seed_staff.php</b></p>
</div></body></html>
