<?php
$router->get('/', function(){ redirect('/dashboard'); });

$router->get('/login',[AuthController::class,'showLogin']);
$router->post('/login',[AuthController::class,'login']);
$router->get('/register',[AuthController::class,'showRegister']);
$router->post('/register',[AuthController::class,'register']);
$router->get('/logout',[AuthController::class,'logout']);

$router->get('/dashboard',[DashboardController::class,'index']);
$router->get('/devices',[DeviceController::class,'index']);
$router->get('/devices/add',[DeviceController::class,'addForm']);
$router->post('/devices/add',[DeviceController::class,'add']);
$router->get('/devices/{id}',[DeviceController::class,'show']);
$router->get('/devices/{id}/invoice',[DeviceController::class,'invoiceDownload']);

$router->get('/op/login',[OperatorAuthController::class,'showLogin']);
$router->post('/op/login',[OperatorAuthController::class,'login']);
$router->get('/op/logout',[OperatorAuthController::class,'logout']);
$router->get('/op/requests',[OperatorController::class,'requests']);
$router->get('/op/requests/{id}',[OperatorController::class,'requestShow']);
$router->post('/op/requests/{id}/decide',[OperatorController::class,'decide']);
